/*
 Highcharts JS v8.0.0 (2019-12-10)

 Sonification module

 (c) 2012-2019 ystein Moseng

 License: www.highcharts.com/license
*/
(function(d){"object"===typeof module&&module.exports?(d["default"]=d,module.exports=d):"function"===typeof define&&define.amd?define("highcharts/modules/sonification",["highcharts"],function(m){d(m);d.Highcharts=m;return d}):d("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(d){function m(e,d,g,h){e.hasOwnProperty(d)||(e[d]=h.apply(null,g))}d=d?d._modules:{};m(d,"modules/sonification/Instrument.js",[d["parts/Globals.js"],d["parts/Utilities.js"]],function(e,d){function g(c){this.init(c)}
var h=d.pick,k={type:"oscillator",playCallbackInterval:20,oscillator:{waveformShape:"sine"}};g.prototype.init=function(c){this.initAudioContext()?(this.options=e.merge(k,c),this.id=this.options.id=c&&c.id||e.uniqueKey(),c=e.audioContext,this.gainNode=c.createGain(),this.setGain(0),(this.panNode=c.createStereoPanner&&c.createStereoPanner())?(this.setPan(0),this.gainNode.connect(this.panNode),this.panNode.connect(c.destination)):this.gainNode.connect(c.destination),"oscillator"===this.options.type&&
this.initOscillator(this.options.oscillator),this.playCallbackTimers=[]):e.error(29)};g.prototype.copy=function(c){return new g(e.merge(this.options,{id:null},c))};g.prototype.initAudioContext=function(){var c=e.win.AudioContext||e.win.webkitAudioContext,b=!!e.audioContext;return c?(e.audioContext=e.audioContext||new c,!b&&e.audioContext&&"running"===e.audioContext.state&&e.audioContext.suspend(),!!(e.audioContext&&e.audioContext.createOscillator&&e.audioContext.createGain)):!1};g.prototype.initOscillator=
function(c){this.oscillator=e.audioContext.createOscillator();this.oscillator.type=c.waveformShape;this.oscillator.connect(this.gainNode);this.oscillatorStarted=!1};g.prototype.setPan=function(c){this.panNode&&this.panNode.pan.setValueAtTime(c,e.audioContext.currentTime)};g.prototype.setGain=function(c,b){this.gainNode&&(1.2<c&&(console.warn("Highcharts sonification warning: Volume of instrument set too high."),c=1.2),b?(this.gainNode.gain.setValueAtTime(this.gainNode.gain.value,e.audioContext.currentTime),
this.gainNode.gain.linearRampToValueAtTime(c,e.audioContext.currentTime+b/1E3)):this.gainNode.gain.setValueAtTime(c,e.audioContext.currentTime))};g.prototype.cancelGainRamp=function(){this.gainNode&&this.gainNode.gain.cancelScheduledValues(0)};g.prototype.getValidFrequency=function(c,b,a){var f=this.options.allowedFrequencies,e=h(a,Infinity),d=h(b,-Infinity);return f&&f.length?f.reduce(function(b,a){return Math.abs(a-c)<Math.abs(b-c)&&a<e&&a>d?a:b},Infinity):c};g.prototype.clearPlayCallbackTimers=
function(){this.playCallbackTimers.forEach(function(c){clearInterval(c)});this.playCallbackTimers=[]};g.prototype.setFrequency=function(c,b){b=b||{};c=this.getValidFrequency(c,b.min,b.max);"oscillator"===this.options.type&&this.oscillatorPlay(c)};g.prototype.oscillatorPlay=function(c){this.oscillatorStarted||(this.oscillator.start(),this.oscillatorStarted=!0);this.oscillator.frequency.setValueAtTime(c,e.audioContext.currentTime)};g.prototype.preparePlay=function(){this.setGain(.001);"suspended"===
e.audioContext.state&&e.audioContext.resume();this.oscillator&&!this.oscillatorStarted&&(this.oscillator.start(),this.oscillatorStarted=!0)};g.prototype.play=function(c){var b=this,a=c.duration||0,f=function(a,f,e){var d=c.duration,k=0,g=b.options.playCallbackInterval;if("function"===typeof a){var p=setInterval(function(){k++;var c=k*g/d;if(1<=c)b[f](a(1),e),clearInterval(p);else b[f](a(c),e)},g);b.playCallbackTimers.push(p)}else b[f](a,e)};if(b.id)if("suspended"===e.audioContext.state||this.oscillator&&
!this.oscillatorStarted)b.preparePlay(),setTimeout(function(){b.play(c)},10);else{b.playCallbackTimers.length&&b.clearPlayCallbackTimers();b.cancelGainRamp();b.stopOscillatorTimeout&&(clearTimeout(b.stopOscillatorTimeout),delete b.stopOscillatorTimeout);b.stopTimeout&&(clearTimeout(b.stopTimeout),delete b.stopTimeout,b.stopCallback&&(b._play=b.play,b.play=function(){},b.stopCallback("cancelled"),b.play=b._play));var d=a<e.sonification.fadeOutDuration+20;b.stopCallback=c.onEnd;var k=function(){delete b.stopTimeout;
b.stop(d)};a?(b.stopTimeout=setTimeout(k,d?a:a-e.sonification.fadeOutDuration),f(c.frequency,"setFrequency",{minFrequency:c.minFrequency,maxFrequency:c.maxFrequency}),f(h(c.volume,1),"setGain",4),f(h(c.pan,0),"setPan")):k()}};g.prototype.mute=function(){this.setGain(.0001,.8*e.sonification.fadeOutDuration)};g.prototype.stop=function(c,b,a){var f=this,d=function(){f.stopOscillatorTimeout&&delete f.stopOscillatorTimeout;try{f.oscillator.stop()}catch(n){}f.oscillator.disconnect(f.gainNode);f.initOscillator(f.options.oscillator);
b&&b(a);f.stopCallback&&f.stopCallback(a)};f.playCallbackTimers.length&&f.clearPlayCallbackTimers();f.stopTimeout&&clearTimeout(f.stopTimeout);c?(f.setGain(0),d()):(f.mute(),f.stopOscillatorTimeout=setTimeout(d,e.sonification.fadeOutDuration+100))};return g});m(d,"modules/sonification/musicalFrequencies.js",[],function(){return[16.351597831287414,17.323914436054505,18.354047994837977,19.445436482630058,20.601722307054366,21.826764464562746,23.12465141947715,24.499714748859326,25.956543598746574,27.5,
29.13523509488062,30.86770632850775,32.70319566257483,34.64782887210901,36.70809598967594,38.890872965260115,41.20344461410875,43.653528929125486,46.2493028389543,48.999429497718666,51.91308719749314,55,58.27047018976124,61.7354126570155,65.40639132514966,69.29565774421802,73.41619197935188,77.78174593052023,82.4068892282175,87.30705785825097,92.4986056779086,97.99885899543733,103.82617439498628,110,116.54094037952248,123.47082531403103,130.8127826502993,138.59131548843604,146.8323839587038,155.56349186104046,
164.81377845643496,174.61411571650194,184.9972113558172,195.99771799087463,207.65234878997256,220,233.08188075904496,246.94165062806206,261.6255653005986,277.1826309768721,293.6647679174076,311.1269837220809,329.6275569128699,349.2282314330039,369.9944227116344,391.99543598174927,415.3046975799451,440,466.1637615180899,493.8833012561241,523.2511306011972,554.3652619537442,587.3295358348151,622.2539674441618,659.2551138257398,698.4564628660078,739.9888454232688,783.9908719634985,830.6093951598903,
880,932.3275230361799,987.7666025122483,1046.5022612023945,1108.7305239074883,1174.6590716696303,1244.5079348883237,1318.5102276514797,1396.9129257320155,1479.9776908465376,1567.981743926997,1661.2187903197805,1760,1864.6550460723597,1975.533205024496,2093.004522404789,2217.4610478149766,2349.31814333926,2489.0158697766474,2637.02045530296,2793.825851464031,2959.955381693075,3135.9634878539946,3322.437580639561,3520,3729.3100921447194,3951.066410048992,4186.009044809578]});m(d,"modules/sonification/utilities.js",
[d["modules/sonification/musicalFrequencies.js"],d["parts/Utilities.js"]],function(e,d){function g(e){this.init(e||[])}var h=d.clamp;g.prototype.init=function(e){this.supportedSignals=e;this.signals={}};g.prototype.registerSignalCallbacks=function(e){var c=this;c.supportedSignals.forEach(function(b){var a=e[b];a&&(c.signals[b]=c.signals[b]||[]).push(a)})};g.prototype.clearSignalCallbacks=function(e){var c=this;e?e.forEach(function(b){c.signals[b]&&delete c.signals[b]}):c.signals={}};g.prototype.emitSignal=
function(e,c){var b;this.signals[e]&&this.signals[e].forEach(function(a){a=a(c);b="undefined"!==typeof a?a:b});return b};return{musicalFrequencies:e,SignalHandler:g,getMusicalScale:function(d){return e.filter(function(e,b){var a=b%12+1;return d.some(function(b){return b===a})})},calculateDataExtremes:function(e,c){return e.series.reduce(function(b,a){a.points.forEach(function(a){a="undefined"!==typeof a[c]?a[c]:a.options[c];b.min=Math.min(b.min,a);b.max=Math.max(b.max,a)});return b},{min:Infinity,
max:-Infinity})},virtualAxisTranslate:function(e,c,b){var a=c.max-c.min;e=b.min+(b.max-b.min)*(e-c.min)/a;return 0<a?h(e,b.min,b.max):b.min}}});m(d,"modules/sonification/instrumentDefinitions.js",[d["modules/sonification/Instrument.js"],d["modules/sonification/utilities.js"]],function(e,d){var g={};["sine","square","triangle","sawtooth"].forEach(function(h){g[h]=new e({oscillator:{waveformShape:h}});g[h+"Musical"]=new e({allowedFrequencies:d.musicalFrequencies,oscillator:{waveformShape:h}});g[h+"Major"]=
new e({allowedFrequencies:d.getMusicalScale([1,3,5,6,8,10,12]),oscillator:{waveformShape:h}})});return g});m(d,"modules/sonification/Earcon.js",[d["parts/Globals.js"],d["parts/Utilities.js"]],function(e,d){function g(e){this.init(e||{})}var h=d.pick;g.prototype.init=function(d){this.options=d;this.options.id||(this.options.id=this.id=e.uniqueKey());this.instrumentsPlaying={}};g.prototype.sonify=function(d){var c=e.merge(this.options,d),b=h(c.volume,1),a=c.pan,f=this,g=d&&d.onEnd,k=f.options.onEnd;
c.instruments.forEach(function(c){var d="string"===typeof c.instrument?e.sonification.instruments[c.instrument]:c.instrument,l=e.merge(c.playOptions),p="";if(d&&d.play){if(c.playOptions){"function"!==typeof c.playOptions.volume&&(l.volume=h(b,1)*h(c.playOptions.volume,1));l.pan=h(a,l.pan);var n=l.onEnd;l.onEnd=function(){delete f.instrumentsPlaying[p];n&&n.apply(this,arguments);Object.keys(f.instrumentsPlaying).length||(g&&g.apply(this,arguments),k&&k.apply(this,arguments))};c=d.copy();p=c.id;f.instrumentsPlaying[p]=
c;c.play(l)}}else e.error(30)})};g.prototype.cancelSonify=function(e){var c=this.instrumentsPlaying,b=c&&Object.keys(c);b&&b.length&&(b.forEach(function(a){c[a].stop(!e,null,"cancelled")}),this.instrumentsPlaying={})};return g});m(d,"modules/sonification/pointSonify.js",[d["parts/Globals.js"],d["parts/Utilities.js"],d["modules/sonification/utilities.js"]],function(e,d,g){var h=d.pick,k={minDuration:20,maxDuration:2E3,minVolume:.1,maxVolume:1,minPan:-1,maxPan:1,minFrequency:220,maxFrequency:2200};
return{pointSonify:function(c){var b=this,a=b.series.chart,f=c.dataExtremes||{},d=function(a,e,c){return"function"===typeof a?e?function(e){return a(b,f,e)}:a(b,f):"string"===typeof a?(f[a]=f[a]||g.calculateDataExtremes(b.series.chart,a),g.virtualAxisTranslate(h(b[a],b.options[a]),f[a],c)):a};a.sonification.currentlyPlayingPoint=b;b.sonification=b.sonification||{};b.sonification.instrumentsPlaying=b.sonification.instrumentsPlaying||{};var n=b.sonification.signalHandler=b.sonification.signalHandler||
new g.SignalHandler(["onEnd"]);n.clearSignalCallbacks();n.registerSignalCallbacks({onEnd:c.onEnd});!b.isNull&&b.visible&&b.series.visible?c.instruments.forEach(function(c){var f="string"===typeof c.instrument?e.sonification.instruments[c.instrument]:c.instrument,g=c.instrumentMapping||{},l=e.merge(k,c.instrumentOptions),h=f.id,p=function(e){c.onEnd&&c.onEnd.apply(this,arguments);a.sonification&&a.sonification.currentlyPlayingPoint&&delete a.sonification.currentlyPlayingPoint;b.sonification&&b.sonification.instrumentsPlaying&&
(delete b.sonification.instrumentsPlaying[h],Object.keys(b.sonification.instrumentsPlaying).length||n.emitSignal("onEnd",e))};f&&f.play?(b.sonification.instrumentsPlaying[f.id]=f,f.play({frequency:d(g.frequency,!0,{min:l.minFrequency,max:l.maxFrequency}),duration:d(g.duration,!1,{min:l.minDuration,max:l.maxDuration}),pan:d(g.pan,!0,{min:l.minPan,max:l.maxPan}),volume:d(g.volume,!0,{min:l.minVolume,max:l.maxVolume}),onEnd:p,minFrequency:l.minFrequency,maxFrequency:l.maxFrequency})):e.error(30)}):n.emitSignal("onEnd")},
pointCancelSonify:function(c){var b=this.sonification&&this.sonification.instrumentsPlaying,a=b&&Object.keys(b);a&&a.length&&(a.forEach(function(a){b[a].stop(!c,null,"cancelled")}),this.sonification.instrumentsPlaying={},this.sonification.signalHandler.emitSignal("onEnd","cancelled"))}}});m(d,"modules/sonification/chartSonify.js",[d["parts/Globals.js"],d["parts/Utilities.js"],d["modules/sonification/utilities.js"]],function(e,d,g){function h(a,b){return"function"===typeof b?b(a):r(a[b],a.options[b])}
function k(a,b){return a.points.reduce(function(a,c){c=h(c,b);a.min=Math.min(a.min,c);a.max=Math.max(a.max,c);return a},{min:Infinity,max:-Infinity})}function c(a,b,c){return(b||[]).reduce(function(b,c){Object.keys(c.instrumentMapping||{}).forEach(function(e){e=c.instrumentMapping[e];"string"!==typeof e||b[e]||(b[e]=g.calculateDataExtremes(a,e))});return b},e.merge(c))}function b(a,b){return b.reduce(function(b,c){var f=c.earcon;c.condition?(c=c.condition(a),c instanceof e.sonification.Earcon?b.push(c):
c&&b.push(f)):c.onPoint&&a.id===c.onPoint&&b.push(f);return b},[])}function a(a){return a.map(function(a){var b=a.instrument;b=("string"===typeof b?e.sonification.instruments[b]:b).copy();return e.merge(a,{instrument:b})})}function f(f,d){var l=d.timeExtremes||k(f,d.pointPlayTime,d.dataExtremes),y=c(f.chart,d.instruments,d.dataExtremes),z=a(d.instruments),n=f.points.reduce(function(a,c){var f=b(c,d.earcons||[]),t=g.virtualAxisTranslate(h(c,d.pointPlayTime),l,{min:0,max:d.duration});return a.concat(new e.sonification.TimelineEvent({eventObject:c,
time:t,id:c.id,playOptions:{instruments:z,dataExtremes:y}}),f.map(function(a){return new e.sonification.TimelineEvent({eventObject:a,time:t})}))},[]);return new e.sonification.TimelinePath({events:n,onStart:function(){if(d.onStart)d.onStart(f)},onEventStart:function(a){var b=a.options&&a.options.eventObject;if(b instanceof e.Point){if(!b.series.visible&&!b.series.chart.series.some(function(a){return a.visible}))return a.timelinePath.timeline.pause(),a.timelinePath.timeline.resetCursor(),!1;if(d.onPointStart)d.onPointStart(a,
b)}},onEventEnd:function(a){var b=a.event&&a.event.options&&a.event.options.eventObject;if(b instanceof e.Point&&d.onPointEnd)d.onPointEnd(a.event,b)},onEnd:function(){if(d.onEnd)d.onEnd(f)}})}function l(a,b,c){var f=c.seriesOptions||{};return e.merge({dataExtremes:b,timeExtremes:k(a,c.pointPlayTime),instruments:c.instruments,onStart:c.onSeriesStart,onEnd:c.onSeriesEnd,earcons:c.earcons},u(f)?e.find(f,function(b){return b.id===r(a.id,a.options.id)})||{}:f,{pointPlayTime:c.pointPlayTime})}function n(a,
b,c){if("sequential"===a||"simultaneous"===a){var f=b.series.reduce(function(a,b){b.visible&&a.push({series:b,seriesOptions:c(b)});return a},[]);"simultaneous"===a&&(f=[f])}else f=a.reduce(function(a,f){f=q(f).reduce(function(a,f){var d;if("string"===typeof f){var g=b.get(f);g.visible&&(d={series:g,seriesOptions:c(g)})}else f instanceof e.sonification.Earcon&&(d=new e.sonification.TimelinePath({events:[new e.sonification.TimelineEvent({eventObject:f})]}));f.silentWait&&(d=new e.sonification.TimelinePath({silentWait:f.silentWait}));
d&&a.push(d);return a},[]);f.length&&a.push(f);return a},[]);return f}function p(a,b){return b?a.reduce(function(c,f,d){f=q(f);c.push(f);d<a.length-1&&f.some(function(a){return a.series})&&c.push(new e.sonification.TimelinePath({silentWait:b}));return c},[]):a}function m(a){return a.reduce(function(a,b){b=q(b);return a+(1===b.length&&b[0].options&&b[0].options.silentWait||0)},0)}function v(a){var b=a.reduce(function(a,b){(b=b.events)&&b.length&&(a.min=Math.min(b[0].time,a.min),a.max=Math.max(b[b.length-
1].time,a.max));return a},{min:Infinity,max:-Infinity});a.forEach(function(a){var c=a.events,f=c&&c.length,d=[];f&&c[0].time<=b.min||d.push(new e.sonification.TimelineEvent({time:b.min}));f&&c[c.length-1].time>=b.max||d.push(new e.sonification.TimelineEvent({time:b.max}));d.length&&a.addTimelineEvents(d)})}function w(a){return a.reduce(function(a,b){return a+q(b).reduce(function(a,b){return(b=b.series&&b.seriesOptions&&b.seriesOptions.timeExtremes)?Math.max(a,b.max-b.min):a},0)},0)}function x(a,b){var c=
Math.max(b-m(a),0),d=w(a);return a.reduce(function(a,b){b=q(b).reduce(function(a,b){b instanceof e.sonification.TimelinePath?a.push(b):b.series&&(b.seriesOptions.duration=b.seriesOptions.duration||g.virtualAxisTranslate(b.seriesOptions.timeExtremes.max-b.seriesOptions.timeExtremes.min,{min:0,max:d},{min:0,max:c}),a.push(f(b.series,b.seriesOptions)));return a},[]);a.push(b);return a},[])}var u=d.isArray,r=d.pick,q=d.splat;return{chartSonify:function(a){this.sonification.timeline&&this.sonification.timeline.pause();
var b=c(this,a.instruments,a.dataExtremes),f=n(a.order,this,function(c){return l(c,b,a)});f=p(f,a.afterSeriesWait||0);f=x(f,a.duration);f.forEach(function(a){v(a)});this.sonification.timeline=new e.sonification.Timeline({paths:f,onEnd:a.onEnd});this.sonification.timeline.play()},seriesSonify:function(a){a=f(this,a);var b=this.chart.sonification;b.timeline&&b.timeline.pause();b.timeline=new e.sonification.Timeline({paths:[a]});b.timeline.play()},pause:function(a){this.sonification.timeline?this.sonification.timeline.pause(r(a,
!0)):this.sonification.currentlyPlayingPoint&&this.sonification.currentlyPlayingPoint.cancelSonify(a)},resume:function(a){this.sonification.timeline&&this.sonification.timeline.play(a)},rewind:function(a){this.sonification.timeline&&this.sonification.timeline.rewind(a)},cancel:function(a){this.pauseSonify(a);this.resetSonifyCursor()},getCurrentPoints:function(){if(this.sonification.timeline){var a=this.sonification.timeline.getCursor();return Object.keys(a).map(function(b){return a[b].eventObject}).filter(function(a){return a instanceof
e.Point})}return[]},setCursor:function(a){var b=this.sonification.timeline;b&&q(a).forEach(function(a){b.setCursor(a.id)})},resetCursor:function(){this.sonification.timeline&&this.sonification.timeline.resetCursor()},resetCursorEnd:function(){this.sonification.timeline&&this.sonification.timeline.resetCursorEnd()}}});m(d,"modules/sonification/Timeline.js",[d["parts/Globals.js"],d["parts/Utilities.js"],d["modules/sonification/utilities.js"]],function(e,d,g){function h(a){this.init(a||{})}function k(a){this.init(a)}
function c(a){this.init(a||{})}var b=d.splat;h.prototype.init=function(a){this.options=a;this.time=a.time||0;this.id=this.options.id=a.id||e.uniqueKey()};h.prototype.play=function(a){var b=this.options.eventObject,c=this.options.onEnd,d=a&&a.onEnd,g=this.options.playOptions&&this.options.playOptions.onEnd;a=e.merge(this.options.playOptions,a);b&&b.sonify?(a.onEnd=c||d||g?function(){var a=arguments;[c,d,g].forEach(function(b){b&&b.apply(this,a)})}:void 0,b.sonify(a)):(d&&d(),c&&c())};h.prototype.cancel=
function(a){this.options.eventObject.cancelSonify(a)};k.prototype.init=function(a){this.options=a;this.id=this.options.id=a.id||e.uniqueKey();this.cursor=0;this.eventsPlaying={};this.events=a.silentWait?[new h({time:0}),new h({time:a.silentWait})]:this.options.events;this.sortEvents();this.updateEventIdMap();this.signalHandler=new g.SignalHandler(["playOnEnd","masterOnEnd","onStart","onEventStart","onEventEnd"]);this.signalHandler.registerSignalCallbacks(e.merge(a,{masterOnEnd:a.onEnd}))};k.prototype.sortEvents=
function(){this.events=this.events.sort(function(a,b){return a.time-b.time})};k.prototype.updateEventIdMap=function(){this.eventIdMap=this.events.reduce(function(a,b,c){a[b.id]=c;return a},{})};k.prototype.addTimelineEvents=function(a){this.events=this.events.concat(a);this.sortEvents();this.updateEventIdMap()};k.prototype.getCursor=function(){return this.events[this.cursor]};k.prototype.setCursor=function(a){a=this.eventIdMap[a];return"undefined"!==typeof a?(this.cursor=a,!0):!1};k.prototype.play=
function(a){this.pause();this.signalHandler.emitSignal("onStart");this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playEvents(1)};k.prototype.rewind=function(a){this.pause();this.signalHandler.emitSignal("onStart");this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playEvents(-1)};k.prototype.resetCursor=function(){this.cursor=0};k.prototype.resetCursorEnd=function(){this.cursor=
this.events.length-1};k.prototype.pause=function(a){var b=this;clearTimeout(b.nextScheduledPlay);Object.keys(b.eventsPlaying).forEach(function(c){b.eventsPlaying[c]&&b.eventsPlaying[c].cancel(a)});b.eventsPlaying={}};k.prototype.playEvents=function(a){var b=this,c=b.events[this.cursor],d=b.events[this.cursor+a],e=function(a){b.signalHandler.emitSignal("masterOnEnd",a);b.signalHandler.emitSignal("playOnEnd",a)};c.timelinePath=b;if(!1===b.signalHandler.emitSignal("onEventStart",c))e({event:c,cancelled:!0});
else if(b.eventsPlaying[c.id]=c,c.play({onEnd:function(a){a={event:c,cancelled:!!a};delete b.eventsPlaying[c.id];b.signalHandler.emitSignal("onEventEnd",a);d||e(a)}}),d){var g=Math.abs(d.time-c.time);1>g?(b.cursor+=a,b.playEvents(a)):this.nextScheduledPlay=setTimeout(function(){b.cursor+=a;b.playEvents(a)},g)}};c.prototype.init=function(a){this.options=a;this.cursor=0;this.paths=a.paths;this.pathsPlaying={};this.signalHandler=new g.SignalHandler(["playOnEnd","masterOnEnd","onPathStart","onPathEnd"]);
this.signalHandler.registerSignalCallbacks(e.merge(a,{masterOnEnd:a.onEnd}))};c.prototype.play=function(a){this.pause();this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playPaths(1)};c.prototype.rewind=function(a){this.pause();this.signalHandler.clearSignalCallbacks(["playOnEnd"]);this.signalHandler.registerSignalCallbacks({playOnEnd:a});this.playPaths(-1)};c.prototype.playPaths=function(a){var c=b(this.paths[this.cursor]),d=this.paths[this.cursor+
a],g=this,h=this.signalHandler,k=0,m=function(e){h.emitSignal("onPathStart",e);g.pathsPlaying[e.id]=e;e[0<a?"play":"rewind"](function(f){f=f&&f.cancelled;var l={path:e,cancelled:f};delete g.pathsPlaying[e.id];h.emitSignal("onPathEnd",l);k++;k>=c.length&&(d&&!f?(g.cursor+=a,b(d).forEach(function(b){b[0<a?"resetCursor":"resetCursorEnd"]()}),g.playPaths(a)):(h.emitSignal("playOnEnd",l),h.emitSignal("masterOnEnd",l)))})};c.forEach(function(a){a&&(a.timeline=g,setTimeout(function(){m(a)},e.sonification.fadeOutDuration))})};
c.prototype.pause=function(a){var b=this;Object.keys(b.pathsPlaying).forEach(function(c){b.pathsPlaying[c]&&b.pathsPlaying[c].pause(a)});b.pathsPlaying={}};c.prototype.resetCursor=function(){this.paths.forEach(function(a){b(a).forEach(function(a){a.resetCursor()})});this.cursor=0};c.prototype.resetCursorEnd=function(){this.paths.forEach(function(a){b(a).forEach(function(a){a.resetCursorEnd()})});this.cursor=this.paths.length-1};c.prototype.setCursor=function(a){return this.paths.some(function(c){return b(c).some(function(b){return b.setCursor(a)})})};
c.prototype.getCursor=function(){return this.getCurrentPlayingPaths().reduce(function(a,b){a[b.id]=b.getCursor();return a},{})};c.prototype.atStart=function(){return!this.getCurrentPlayingPaths().some(function(a){return a.cursor})};c.prototype.getCurrentPlayingPaths=function(){return b(this.paths[this.cursor])};return{TimelineEvent:h,TimelinePath:k,Timeline:c}});m(d,"modules/sonification/sonification.js",[d["parts/Globals.js"],d["parts/Utilities.js"],d["modules/sonification/Instrument.js"],d["modules/sonification/instrumentDefinitions.js"],
d["modules/sonification/Earcon.js"],d["modules/sonification/pointSonify.js"],d["modules/sonification/chartSonify.js"],d["modules/sonification/utilities.js"],d["modules/sonification/Timeline.js"]],function(d,m,g,h,k,c,b,a,f){var e=d.addEvent;m=m.extend;d.sonification={fadeOutDuration:20,utilities:a,Instrument:g,instruments:h,Earcon:k,TimelineEvent:f.TimelineEvent,TimelinePath:f.TimelinePath,Timeline:f.Timeline};d.Point.prototype.sonify=c.pointSonify;d.Point.prototype.cancelSonify=c.pointCancelSonify;
d.Series.prototype.sonify=b.seriesSonify;m(d.Chart.prototype,{sonify:b.chartSonify,pauseSonify:b.pause,resumeSonify:b.resume,rewindSonify:b.rewind,cancelSonify:b.cancel,getCurrentSonifyPoints:b.getCurrentPoints,setSonifyCursor:b.setCursor,resetSonifyCursor:b.resetCursor,resetSonifyCursorEnd:b.resetCursorEnd});e(d.Chart,"init",function(){this.sonification={}})});m(d,"masters/modules/sonification.src.js",[],function(){})});
//# sourceMappingURL=sonification.js.map